<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly!
}

if ( ! class_exists( 'WPSC_AG_Action' ) ) :

	final class WPSC_AG_Action {

		/**
		 * Initialize this class
		 *
		 * @return void
		 */
		public static function init() {

			// Delete user from agentgroup.
			add_action( 'wpsc_delete_agent', array( __CLASS__, 'delete_user_from_agentgroup' ) );

			add_filter( 'wpsc_checklist_modify_agent_list', array( __CLASS__, 'checklist_modify_agent_list' ), 10, 3 );
		}

		/**
		 * Delete user from agentgroup
		 *
		 * @param WPSC_Agent $agent - agent object.
		 * @return void
		 */
		public static function delete_user_from_agentgroup( $agent ) {

			$agentgroups = WPSC_Agentgroup::find(
				array(
					'meta_query' => array(
						'relation' => 'AND',
						array(
							'slug'    => 'agents',
							'compare' => 'IN',
							'val'     => array( $agent->id ),
						),
					),
				)
			)['results'];

			foreach ( $agentgroups as $agentgroup ) {

				$agents = $agentgroup->agents;
				$index  = array_search( $agent, $agents );
				if ( $index !== false ) {
					unset( $agents[ $index ] );
					if ( $agents ) {
						$agentgroup->agents = $agents;
						$agentgroup->save();
					} else {
						WPSC_Agentgroup::destroy( $agentgroup );
						continue;
					}
				}

				$supervisors = $agentgroup->supervisors;
				$index       = array_search( $agent, $supervisors );
				if ( $index !== false ) {
					unset( $supervisors[ $index ] );
					$agentgroup->supervisors = $supervisors;
					$agentgroup->save();
				}
			}
		}

		/**
		 * Modify agent list for checklist
		 *
		 * @param array             $agent_ids - agent id.
		 * @param WPSC_Current_User $current_user - current user object.
		 * @param WPSC_Ticket       $ticket - ticket object.
		 * @return bool
		 */
		public static function checklist_modify_agent_list( $agent_ids, $current_user, $ticket ) {

			foreach ( $agent_ids as $id ) {

				$agent = new WPSC_Agent( $id );
				if ( ! $agent->id || ! $agent->is_active || ! $agent->is_agentgroup ) {
					continue;
				}

				$agentgroup = WPSC_Agentgroup::get_by_agent_id( $agent->id );
				if ( ! $agentgroup->id ) {
					continue;
				}

				$supervisors = array_map(
					function ( $supervisor ) {
						return $supervisor->id;
					},
					$agentgroup->supervisors
				);

				$agent_ids = array_merge( $agent_ids, $supervisors );
			}

			return $agent_ids;
		}
	}
endif;
WPSC_AG_Action::init();
